##### Rozdział 9: klasteryzacja metodą k-średnich -------------------

## Przykład: znajdowanie segmentów rynkowych wśród nastolatków ----
## Etap 2: badanie i przygotowywanie danych ----
teens <- read.csv("snsdata.csv", stringsAsFactors = TRUE)
str(teens)

# przyglądamy się brakującym danym dla zmiennej gender
table(teens$gender)
table(teens$gender, useNA = "ifany")

# przyglądamy się brakującym danym dla zmiennej age
summary(teens$age)

# eliminujemy odstające wartości wieku
teens$age <- ifelse(teens$age >= 13 & teens$age < 20,
                     teens$age, NA)

summary(teens$age)

# ustawiamy brakujące wartości wieku na "nieznany"
teens$female <- ifelse(teens$gender == "F" &
                         !is.na(teens$gender), 1, 0)
teens$no_gender <- ifelse(is.na(teens$gender), 1, 0)

# sprawdzamy wyniki przekodowywania
table(teens$gender, useNA = "ifany")
table(teens$female, useNA = "ifany")
table(teens$no_gender, useNA = "ifany")

# znajdujemy średni wiek wg kohorty
mean(teens$age) # nie działa
mean(teens$age, na.rm = TRUE) # działa

# wiek wg kohorty
aggregate(data = teens, age ~ gradyear, mean, na.rm = TRUE)

# tworzymy wektor ze średnim wiekiem dla każdego rocznika
ave_age <- ave(teens$age, teens$gradyear,
                 FUN = function(x) mean(x, na.rm = TRUE))


teens$age <- ifelse(is.na(teens$age), ave_age, teens$age)

# sprawdzamy zbiorcze wyniki, aby upewnić się, że brakujące wartości zostały wyeliminowane
summary(teens$age)

## Etap 3: trenowanie modelu na danych

# tworzymy ramkę danych poddaną standaryzacji Z w celu ułatwienia interpretacji
interests <- teens[5:40]
interests_z <- as.data.frame(lapply(interests, scale))

# porównujemy dane przed i po przekształceniu
summary(interests$basketball)
summary(interests_z$basketball)

# tworzymy klastry metodą k-średnich
set.seed(2345)
teen_clusters <- kmeans(interests_z, 5)

## Etap 4: ewaluacja modelu ----
# przyglądamy się rozmiarowi klastrów
teen_clusters$size

# przyglądamy się centrom klastrów
teen_clusters$centers

# opcjonalnie: wizualizujemy klastry za pomocą pakietu factoextra
# (wyników nie pokazano w książce)
library(factoextra)
fviz_cluster(teen_clusters, interests_z, geom = "point")

## Etap 5: poprawianie działania modelu ----
# stosujemy identyfikatory klastrów do pierwotnej ramki danych
teens$cluster <- teen_clusters$cluster

# przyglądamy się pierwszym pięciu rekordom
teens[1:5, c("cluster", "gender", "age", "friends")]

# średni wiek wg klastra
aggregate(data = teens, age ~ cluster, mean)

# proporcja kobiet wg klastra
aggregate(data = teens, female ~ cluster, mean)

# średnia liczba znajomych wg klastra
aggregate(data = teens, friends ~ cluster, mean)
